<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>

        body {
            margin: 0;
            padding: 0;
            font-family: 'Arial', sans-serif;
            background-image: url('http://7system.com.br/img/cloud2.jpg'); /* Substitua 'sua_imagem_de_nuvem.jpg' pelo caminho da sua imagem de nuvem */
            background-size: cover;
            background-attachment: fixed;
            background-color: rgba(255, 255, 255, 0.9); /* Opacidade de 50% - ajuste conforme necessário */
        }

        form {
            display: inline-block;
            text-align: left;
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 5px;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;

        }

        table, th, td {
            border: 1px solid #ddd;


        }

        th, td {
            padding: 10px;
            text-align: center;
            font-weight: bold
        }

        th {
            background-color: #4CAF50;
            font-weight: bold
        }

        h1 {
            text-align: center;
            margin-top: 30px;
        }
    </style>
    <title>Pesquisa Dinâmica</title>
</head>
<body>

<h1>Pesquisa Dinâmica</h1>

<div style="margin: 0 auto; width: 50%;">

<?php
$servername = "149.56.34.221";
$username = "cegosa24h";
$password = "hospital@1234!";
$database = "cegosa24h";

$conn = new mysqli($servername, $username, $password, $database);

$tables = array(
    'speedtest_adm', 'speedtest_cpd', 'speedtest_cobranca',
    'speedtest_imagem', 'speedtest_recepcao_terreo', 'speedtest_sala19',
    'speedtest_cirurgia', 'speedtest_internacao'
);

$tableName = isset($_GET['table']) && in_array($_GET['table'], $tables) ? $_GET['table'] : 'speedtest_adm';
$filterIP = isset($_GET['ip']) ? $_GET['ip'] : '';
$filterHostname = isset($_GET['hostname']) ? $_GET['hostname'] : '';

$sql = "SELECT st.id as ID, st.timestamp as DateTime, h.hostname, st.ip, ROUND(dl,0) as Down, ROUND(ul,0) as UP, ROUND(ping,0) as Ping, ROUND(jitter,0) as Jitter
        FROM $tableName as st
        INNER JOIN hosts as h ON st.ip = h.ip
        WHERE h.ip LIKE '%$filterIP%' AND h.hostname LIKE '%$filterHostname%'
        ORDER BY 1 DESC";

$result = $conn->query($sql);
?>

<form method="get" action="">
    <label for="table">Escolha a tabela:</label>
    <select name="table" id="table">
        <?php foreach ($tables as $table) { ?>
            <option value="<?php echo $table; ?>" <?php echo ($table == $tableName ? 'selected' : ''); ?>><?php echo $table; ?></option>
        <?php } ?>
    </select>

    <label for="ip">Filtrar por IP:</label>
    <input type="text" name="ip" value="<?php echo $filterIP; ?>">

    <label for="hostname">Filtrar por Hostname:</label>
    <input type="text" name="hostname" value="<?php echo $filterHostname; ?>">

    <input type="submit" value="Selecionar">
</form>

</div>

<?php if ($result->num_rows > 0) { ?>
    <table>
        <tr>
            <?php while ($fieldinfo = $result->fetch_field()) { ?>
                <th><?php echo $fieldinfo->name; ?></th>
            <?php } ?>
        </tr>

        <?php while ($row = $result->fetch_assoc()) { ?>
            <tr>
                <?php foreach ($row as $value) { ?>
                    <td><?php echo $value; ?></td>
                <?php } ?>
            </tr>
        <?php } ?>
    </table>
<?php } else { ?>
    <p>Nenhum resultado encontrado.</p>
<?php } ?>

<?php
$conn->close();
?>
</body>
</html>
